/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.crops.TrellisBlock;
import cloud.lemonslice.teastory.block.crops.VineInfoManager;
import cloud.lemonslice.teastory.block.crops.VineType;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.blockentity.VineBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class TrellisWithVineBlock
extends TrellisBlock
implements EntityBlock,
BonemealableBlock {
    private static final VoxelShape[] SHAPES;
    private final VineType type;

    public TrellisWithVineBlock(VineType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getEmptyTrellis(state));
    }

    private void onSignal(ServerLevel level, BlockPos pos, BlockState state, int energy, Direction from, RandomSource random) {
        if (energy <= 0 || !(state.m_60734_() instanceof TrellisBlock)) {
            return;
        }
        --energy;
        if (!(state.m_60734_() instanceof TrellisWithVineBlock)) {
            if (random.m_188499_()) {
                level.m_7731_(pos, VineInfoManager.getVineTrellis(this.type, (TrellisBlock)state.m_60734_()).getRelevantState(state), 2);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof VineBlockEntity) {
                    VineBlockEntity vineBlockEntity = (VineBlockEntity)blockEntity;
                    vineBlockEntity.setDistance(7 - energy);
                }
            }
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VineBlockEntity) {
            VineBlockEntity vineBlockEntity = (VineBlockEntity)blockEntity;
            if (vineBlockEntity.getAge() < 3) {
                vineBlockEntity.setAge(vineBlockEntity.getAge() + 1);
            } else {
                ArrayList<Direction> a = new ArrayList<Direction>(List.of(Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.UP));
                a.remove(from);
                ArrayList<Direction> b = new ArrayList<Direction>();
                for (Direction direction : a) {
                    if (!(level.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof TrellisBlock)) continue;
                    b.add(direction);
                }
                if (!b.isEmpty()) {
                    Direction select = (Direction)b.get(random.m_188503_(b.size()));
                    this.onSignal(level, pos.m_121945_(select), level.m_8055_(pos.m_121945_(select)), energy, select.m_122424_(), random);
                }
                if (this.hasHorizontalBar(state)) {
                    int i = vineBlockEntity.getAge();
                    float f = 5.0f;
                    if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                        if (!this.hasPost(state)) {
                            if (random.m_188499_()) {
                                if (level.m_8055_(pos.m_7495_()).m_60734_() != this.type.getFruit()) {
                                    vineBlockEntity.setAge((i + 1) % 4);
                                }
                            } else if (level.m_8055_(pos.m_7495_()).m_60795_() && !TrellisWithVineBlock.hasNearFruit((Level)level, pos.m_7495_(), this.type.getFruit())) {
                                vineBlockEntity.setAge((i + 1) % 4);
                                level.m_7731_(pos.m_7495_(), this.type.getFruit().m_49966_(), 2);
                                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                                return;
                            }
                        }
                        ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    }
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof VineBlockEntity)) {
            return;
        }
        VineBlockEntity vineBlockEntity = (VineBlockEntity)blockEntity;
        if (!level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            return;
        }
        vineBlockEntity.setDistance(0);
        int energy = 7;
        if (vineBlockEntity.getAge() == 3) {
            for (Direction direction : List.of(Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.UP)) {
                BlockState nextState = level.m_8055_(pos.m_121945_(direction));
                if (!(nextState.m_60734_() instanceof TrellisBlock)) continue;
                this.onSignal(level, pos.m_121945_(direction), nextState, energy, direction.m_122424_(), random);
            }
        } else {
            vineBlockEntity.setAge(vineBlockEntity.getAge() + 1);
        }
    }

    public static boolean hasNearFruit(Level worldIn, BlockPos pos, Block fruit) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState state = worldIn.m_8055_(pos.m_121945_(direction));
            if (!state.m_60713_(fruit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int bar = this.hasHorizontalBar(state) ? 4 : 0;
        int post = this.hasPost(state) ? 2 : 0;
        int up = (Boolean)state.m_61143_((Property)UP) != false ? 1 : 0;
        return SHAPES[bar + post + up];
    }

    public int getNearDistance(LevelAccessor world, BlockPos pos) {
        int distance = 7;
        for (Direction direction : List.of(Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH)) {
            distance = Math.min(distance, this.getDistance(world.m_7702_(pos.m_121945_(direction))));
        }
        return distance;
    }

    public int getNearDistance2(LevelAccessor world, BlockPos pos) {
        int distance = 7;
        for (Direction direction : List.of(Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.DOWN)) {
            distance = Math.min(distance, this.getDistance(world.m_7702_(pos.m_121945_(direction))));
        }
        return distance;
    }

    public int getDistance(BlockEntity blockEntity) {
        if (blockEntity instanceof VineBlockEntity) {
            VineBlockEntity otherVineBlockEntity = (VineBlockEntity)blockEntity;
            if (((TrellisWithVineBlock)otherVineBlockEntity.m_58900_().m_60734_()).type == this.type) {
                return otherVineBlockEntity.getDistance();
            }
        }
        return 7;
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!(level instanceof ServerLevel)) {
            return stateIn;
        }
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState, facingState.m_60783_((BlockGetter)level, facingPos, facing.m_122424_()))));
        } else if (facing == Direction.DOWN) {
            BlockPos posDown = pos.m_121945_(facing);
            state = level.m_8055_(posDown);
            stateIn = (BlockState)stateIn.m_61124_((Property)POST, (Comparable)Boolean.valueOf(state.m_60734_() instanceof TrellisWithVineBlock || state.m_204336_(BlockTags.f_13098_) || state.m_60783_((BlockGetter)level, posDown, Direction.UP)));
        } else if (facing == Direction.UP) {
            BlockPos posUp = pos.m_121945_(facing);
            state = level.m_8055_(posUp);
            stateIn = (BlockState)stateIn.m_61124_((Property)UP, (Comparable)Boolean.valueOf(state.m_60734_() instanceof TrellisWithVineBlock || state.m_204336_(BlockTags.f_13098_) || state.m_60783_((BlockGetter)level, posUp, Direction.DOWN)));
        }
        boolean valid = false;
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            valid = false;
        } else if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            valid = true;
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof VineBlockEntity) {
                VineBlockEntity vineBlockEntity = (VineBlockEntity)blockEntity;
                int nearD = this.getNearDistance2(level, pos);
                if (nearD < vineBlockEntity.getDistance()) {
                    valid = true;
                    if (nearD + 1 < vineBlockEntity.getDistance()) {
                        // empty if block
                    }
                }
            }
        }
        if (!valid) {
            stateIn = VineInfoManager.getEmptyTrellis(stateIn.m_60734_()).getRelevantState(stateIn);
        }
        return stateIn;
    }

    public Block getEmptyTrellis(BlockState state) {
        return VineInfoManager.getEmptyTrellis(state.m_60734_());
    }

    @Override
    public BlockState getRelevantState(BlockState old) {
        BlockState newState = super.getRelevantState(old);
        return newState;
    }

    public VineType getType() {
        return this.type;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (BlockEntityRegister.VINE_TYPE == null) {
            return null;
        }
        return ((BlockEntityType)BlockEntityRegister.VINE_TYPE.get()).m_155264_(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this.getEmptyTrellis(state))});
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        if (!(pLevel.m_7702_(pPos) instanceof VineBlockEntity)) {
            return false;
        }
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_144274_);
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        if (!(pLevel.m_7702_(pPos) instanceof VineBlockEntity)) {
            return false;
        }
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_144274_);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState pState) {
        this.m_213898_(pState, level, pos, random);
    }

    static {
        VoxelShape TOP_SHAPE = VoxelShapeHelper.createVoxelShape(0.0, 4.0, 0.0, 16.0, 9.0, 16.0);
        VoxelShape POST_SHAPE = VoxelShapeHelper.createVoxelShape(6.0, 0.0, 6.0, 4.0, 12.0, 4.0);
        VoxelShape POST_UP_SHAPE = VoxelShapeHelper.createVoxelShape(6.0, 7.0, 6.0, 4.0, 9.0, 4.0);
        SHAPES = new VoxelShape[]{TOP_SHAPE, POST_UP_SHAPE, POST_SHAPE, Shapes.m_83110_((VoxelShape)POST_UP_SHAPE, (VoxelShape)POST_SHAPE), TOP_SHAPE, Shapes.m_83110_((VoxelShape)TOP_SHAPE, (VoxelShape)POST_UP_SHAPE), Shapes.m_83110_((VoxelShape)TOP_SHAPE, (VoxelShape)POST_SHAPE), Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{POST_UP_SHAPE, POST_SHAPE})};
    }
}

